function [E,H] = near_fields(pos, alphae, alphah, alphaeh, EHsol, EH0, ...
    k0, posEv, epsout, TF)

% Function for complete calculation of electric and magnetic field at any
% point outside the scatterer. For far field calculations I recomend
% far_fields function.

%%%%%% INPUT ARGUMENTS %%%%%%
%%% pos:     position of the dipoles                                 %%%
%%% alphae:  electric polarizabilities of the dipoles                %%%
%%% alphah:  magnetic polarizabilities of the dipoles                %%%
%%% alphaeh: mixed magnetic electric polarizabilities of the dipoles %%%
%%% EHsol:   total exciting electromagnetic field at each dipole     %%%
%%% EH0:     exciting electromagnetic wave (6D vectorial function)   %%%
%%% k0:      wavenumber                                              %%%
%%% posEv:   position where the EM field wants to be calculated      %%%
%%% espout:  surrounding permittivity                                %%%
%%% TF:      total field interrogant (scattered + exciting)          %%%


%%%%%% OUTPUT ARGUMENTS %%%%%%
%%% E: electric scattered field %%%
%%% H: magnetic scattered field %%%

% Constants %
load('vacPer.mat','eps0','mu0');
eps0 = epsout*eps0;
Z0   = sqrt(mu0/eps0);

% Data for loops %
N  = length(pos(:,1));
K  = length(k0);
E  = zeros(K,3);
H  = E;

% If L = 2, the polarizability is wavelength indepndent and the same for
% all dipole. If K>1 and L = 3 the polarizability is only a function of
% the wavelength and if L = 4 it also depends on the position (dipole).
% If K = 1 and L = 3 it only depndends on the position and if L = 2 the
% polarizability is wavelength independent and the same for all dipoles.
S = size(alphae);
L = length(S);


if(K > 1)
    if(L > 3)
        parfor i = 1:K

            EHinc = squeeze(EHsol(i,:,:));
            
            for j = 1:N

                ae  = squeeze(alphae(i,j,:,:));
                ah  = squeeze(alphah(i,j,:,:));
                aeh = squeeze(alphaeh(i,j,:,:));
                p = ae*EHinc(j,1:3).' - 1i*mu0*aeh*(EHinc(j,4:6)).';
                m = ah*EHinc(j,4:6).' + 1i*aeh*(EHinc(j,1:3)).';
                r = posEv.'-pos(j,:).';
                R = norm(r);
                n = r/R;

                E(i,:) = E(i,:).'+(exp(1i*k0(i)*R)/(4*pi*eps0*R))*...
                    ((k0(i)^2-1/R^2+1i*k0(i)/R)*p +(dot(n,p))*...
                    (-k0(i)^2+3/R^2-3*1i*k0(i)/R)*n)-...
                    (exp(1i*k0(i)*R)/(4*pi*R))*sqrt(mu0/eps0)*...
                    (k0(i)^2+1i*k0(i)/R)*cross(n,m);

                H(i,:) = H(i,:).'+(exp(1i*k0(i)*R)/(4*pi*R))*...
                    ((k0(i)^2-1/R^2+1i*k0(i)/R)*m +(dot(n,m))*...
                    (-k0(i)^2+3/R^2-3*1i*k0(i)/R)*n)+...
                    (exp(1i*k0(i)*R)/(4*pi*R*sqrt(mu0*eps0)))*...
                    (k0(i)^2+1i*k0(i)/R)*cross(n,p);

            end

        end
    else
        parfor i = 1:K
        
            EHinc = squeeze(EHsol(i,:,:));
            ae    = squeeze(alphae(i,:,:));
            ah    = squeeze(alphah(i,:,:));
            aeh   = squeeze(alphaeh(i,:,:));

            for j = 1:N
                
                p = ae*EHinc(j,1:3).' - 1i*mu0*aeh*(EHinc(j,4:6)).';
                m = ah*EHinc(j,4:6).' + 1i*aeh*(EHinc(j,1:3)).';
                r = posEv.'-pos(j,:).';
                R = norm(r);
                n = r/R;

                E(i,:) = E(i,:).'+(exp(1i*k0(i)*R)/(4*pi*eps0*R))*...
                    ((k0(i)^2-1/R^2+1i*k0(i)/R)*p +(dot(n,p))*...
                    (-k0(i)^2+3/R^2-3*1i*k0(i)/R)*n)-...
                    (exp(1i*k0(i)*R)/(4*pi*R))*sqrt(mu0/eps0)*...
                    (k0(i)^2+1i*k0(i)/R)*cross(n,m);

                H(i,:) = H(i,:).'+(exp(1i*k0(i)*R)/(4*pi*R))*...
                    ((k0(i)^2-1/R^2+1i*k0(i)/R)*m +(dot(n,m))*...
                    (-k0(i)^2+3/R^2-3*1i*k0(i)/R)*n)+...
                    (exp(1i*k0(i)*R)/(4*pi*R*sqrt(mu0*eps0)))*...
                    (k0(i)^2+1i*k0(i)/R)*cross(n,p);

            end
            
        end
    end
   
else
    
    EHinc = squeeze(EHsol);

    if( L > 2)

        for j = 1:N

            ae  = squeeze(alphae(j,:,:));
            ah  = squeeze(alphah(j,:,:));
            aeh = squeeze(alphaeh(j,:,:));
            p = ae*EHinc(j,1:3).' - 1i*mu0*aeh*(EHinc(j,4:6)).';
            m = ah*EHinc(j,4:6).' + 1i*aeh*(EHinc(j,1:3)).';
            r = posEv.'-pos(j,:).';
            R = norm(r);
            n = r/R;

            E(:) = E(:)+(exp(1i*k0*R)/(4*pi*eps0*R))*...
                ((k0^2-1/R^2+1i*k0/R)*p +(dot(n,p))*...
                (-k0^2+3/R^2-3*1i*k0/R)*n)-...
                (exp(1i*k0*R)/(4*pi*R))*sqrt(mu0/eps0)*...
                (k0^2+1i*k0/R)*cross(n,m);

            H(:) = H(:)+(exp(1i*k0*R)/(4*pi*R))*...
                ((k0^2-1/R^2+1i*k0/R)*m +(dot(n,m))*...
                (-k0^2+3/R^2-3*1i*k0/R)*n)+...
                (exp(1i*k0*R)/(4*pi*R*sqrt(mu0*eps0)))*...
                (k0^2+1i*k0/R)*cross(n,p);
            
        end


    else
    
        for j = 1:N
            p = alphae*EHinc(j,1:3).' - 1i*mu0*alphaeh*(EHinc(j,4:6)).';
            m = alphah*EHinc(j,4:6).' + 1i*alphaeh*(EHinc(j,1:3)).';
            r = posEv.'-pos(j,:).';
            R = norm(r);
            n = r/R;

            E(:) = E(:)+(exp(1i*k0*R)/(4*pi*eps0*R))*...
                ((k0^2-1/R^2+1i*k0/R)*p +(dot(n,p))*...
                (-k0^2+3/R^2-3*1i*k0/R)*n)-...
                (exp(1i*k0*R)/(4*pi*R))*sqrt(mu0/eps0)*...
                (k0^2+1i*k0/R)*cross(n,m);

            H(:) = H(:)+(exp(1i*k0*R)/(4*pi*R))*...
                ((k0^2-1/R^2+1i*k0/R)*m +(dot(n,m))*...
                (-k0^2+3/R^2-3*1i*k0/R)*n)+...
                (exp(1i*k0*R)/(4*pi*R*sqrt(mu0*eps0)))*...
                (k0^2+1i*k0/R)*cross(n,p);
        end

    end


end


if(TF ==1)  
    parfor i = 1:K
        EHinc0 = EH0(Z0,k0(i),posEv);

        E(i,:) = E(i,:) + EHinc0(1:3).';
        H(i,:) = H(i,:) + EHinc0(4:6).';
    end
end


end
